/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.furniture.block.AbstractChair;
import org.betterx.bclib.util.BlocksHelper;

public abstract class BaseChair
extends AbstractChair {
    private static final VoxelShape SHAPE_BOTTOM = BaseChair.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_TOP = BaseChair.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    private static final VoxelShape COLLIDER = BaseChair.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");

    public BaseChair(Block block) {
        super(block, 10);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING, TOP});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.m_61143_((Property)TOP) != false ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.m_61143_((Property)TOP) != false ? Shapes.m_83040_() : COLLIDER;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return true;
        }
        BlockState up = world.m_8055_(pos.m_7494_());
        return up.m_60795_() || up.m_60734_() == this && (Boolean)up.m_61143_((Property)TOP) != false;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.m_5776_()) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_7494_(), (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return world.m_8055_(pos.m_7495_()).m_60734_() == this ? state : Blocks.f_50016_.m_49966_();
        }
        return world.m_8055_(pos.m_7494_()).m_60734_() == this ? state : Blocks.f_50016_.m_49966_();
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (!((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        return Collections.emptyList();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
            pos = pos.m_7495_();
            state = world.m_8055_(pos);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.m_7500_() && ((Boolean)state.m_61143_((Property)TOP)).booleanValue() && world.m_8055_(pos.m_7495_()).m_60734_() == this) {
            world.m_46597_(pos.m_7495_(), Blocks.f_50016_.m_49966_());
        }
        super.m_5707_(world, pos, state, player);
    }

    public static BaseChair from(Block source) {
        return BehaviourHelper.from(source, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BaseChair
    implements BehaviourMetal {
        public Metal(Block block) {
            super(block);
        }
    }

    public static class Stone
    extends BaseChair
    implements BehaviourStone {
        public Stone(Block block) {
            super(block);
        }
    }

    public static class Wood
    extends BaseChair
    implements BehaviourWood {
        public Wood(Block block) {
            super(block);
        }
    }
}

